Create or Replace PACKAGE pkg_ALKINDI_SEARCH
AS
  TYPE SEARCH_cursor_type is REF CURSOR;

  PROCEDURE sp_SEL_UserID_By_Screenname(
	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_Simple(
	i_FIELD			IN		VARCHAR2,
	i_CRITERIA			IN		VARCHAR2,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_Advance(
	i_TITLE			IN		MOVIE.TITLE%TYPE,
	i_MOVIE_DESC		IN		MOVIE.MOVIE_DESC%TYPE,
	i_ACTOR			IN		MOVIE.ACTOR%TYPE,
	i_DIRECTOR			IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_Advance_Old(
	i_TITLE			IN		MOVIE.TITLE%TYPE,
	i_MOVIE_DESC		IN		MOVIE.MOVIE_DESC%TYPE,
	i_ACTOR			IN		MOVIE.ACTOR%TYPE,
	i_DIRECTOR			IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_by_Primary_Title(
	i_TITLE					IN		MOVIE.TITLE%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_by_Director(
	i_DIRECTOR				IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_by_Director_Sndex(
	i_DIRECTOR				IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_by_Actor(
	i_ACTOR			  	  	IN		MOVIE.ACTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

  PROCEDURE sp_SEL_Movie_by_Actor_Soundex(
	i_ACTOR			  	  	IN		MOVIE.ACTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER);

END pkg_ALKINDI_SEARCH;
/

Create or Replace PACKAGE BODY pkg_ALKINDI_SEARCH
AS

  PROCEDURE sp_SEL_UserID_By_Screenname(						-- Search for USER_IDs that have a Screenname similar to the one submitted

	i_SCREENNAME		IN		USER_DETAIL.SCREENNAME%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
  IS
	v_SEARCH_CRITERIA VARCHAR2(17);
  BEGIN
	o_ERROR_CODE	:= 0;
	v_SEARCH_CRITERIA	:= lower('%'||i_SCREENNAME||'%');

	OPEN o_SEARCH_cursor_type FOR
	SELECT USER_ID
	     , SCREENNAME
	  FROM USER_DETAIL
	 WHERE SCREENNAME LIKE v_SEARCH_CRITERIA;

   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= 6565;
		CLOSE o_SEARCH_cursor_type;
 END sp_SEL_UserID_By_Screenname;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_Simple(

-- A simple search for movies by field and criteria

	i_FIELD			IN		VARCHAR2,
	i_CRITERIA			IN		VARCHAR2,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)
   IS
	v_SQL VARCHAR2(1000) ;
   BEGIN

	o_ERROR_CODE	:= 0;

	v_SQL :='SELECT PRODUCT_ID FROM MOVIE WHERE UPPER('
		||i_FIELD
		||') LIKE UPPER('
		||''''
		||'%'
		|| i_CRITERIA
		||'%'
		||''''
		||')';

	OPEN o_SEARCH_cursor_type FOR v_SQL;

 EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
		CLOSE o_SEARCH_cursor_type;
 END sp_SEL_Movie_Simple;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_Advance_Old(

-- An advanced search for movies by title, movie_description, actor and director

	i_TITLE			IN		MOVIE.TITLE%TYPE,
	i_MOVIE_DESC		IN		MOVIE.MOVIE_DESC%TYPE,
	i_ACTOR			IN		MOVIE.ACTOR%TYPE,
	i_DIRECTOR			IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE		OUT		NUMBER)

  IS
	v_SEARCH_TITLE		 VARCHAR2(2000);
	v_SEARCH_MOVIE_DESC	 VARCHAR2(2000);
	v_SEARCH_ACTOR		 VARCHAR2(2000);
	v_SEARCH_DIRECTOR		 VARCHAR2(2000);
  BEGIN
	o_ERROR_CODE		:= 0;
	v_SEARCH_TITLE		:= '%'||i_TITLE||'%';
	v_SEARCH_MOVIE_DESC	:= '%'||i_MOVIE_DESC||'%';
	v_SEARCH_ACTOR		:= '%'||i_ACTOR||'%';
	v_SEARCH_DIRECTOR		:= '%'||i_DIRECTOR||'%';

	OPEN o_SEARCH_cursor_type FOR
	SELECT PRODUCT_ID
	  FROM MOVIE
	 WHERE UPPER(TITLE)		LIKE UPPER(v_SEARCH_TITLE)
	   AND UPPER(MOVIE_DESC)	LIKE UPPER(v_SEARCH_MOVIE_DESC)
	   AND UPPER(ACTOR)		LIKE UPPER(v_SEARCH_ACTOR)
	   AND UPPER(DIRECTOR)		LIKE UPPER(v_SEARCH_DIRECTOR);

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6567;						-- general errors when performing advanced search for movies
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_Advance_Old;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_Advance(
	i_TITLE					IN		MOVIE.TITLE%TYPE,
	i_MOVIE_DESC			IN		MOVIE.MOVIE_DESC%TYPE,
	i_ACTOR					IN		MOVIE.ACTOR%TYPE,
	i_DIRECTOR				IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS
	v_SEARCH_cursor_type	SEARCH_cursor_type;
	v_ERROR_CODE			NUMBER;
  BEGIN
	o_ERROR_CODE		:= 0;

	if (length(i_TITLE) > 0) then
	   sp_SEL_Movie_by_Primary_Title(i_TITLE, v_SEARCH_cursor_type, v_ERROR_CODE);
	elsif (length(i_DIRECTOR) > 0) then
       sp_SEL_Movie_by_Director(i_DIRECTOR, v_SEARCH_cursor_type, v_ERROR_CODE);
	elsif (length(i_ACTOR) > 0) then
       sp_SEL_Movie_by_Actor(i_ACTOR, v_SEARCH_cursor_type, v_ERROR_CODE);
	end if;

    o_SEARCH_cursor_type := v_SEARCH_cursor_type;
    o_ERROR_CODE 		:= v_ERROR_CODE;

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6567;						-- general errors when performing advanced search for movies
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_Advance;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_by_Primary_Title(
	i_TITLE					IN		MOVIE.TITLE%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_SEARCH_TITLE		 VARCHAR2(2000);
  BEGIN
	o_ERROR_CODE		:= 0;
	v_SEARCH_TITLE		:= lower('%'||i_TITLE||'%');

--    SELECT /*+FIRST_ROWS*/
--      MAP.PRODUCT_ID
--    FROM
--      MUZE.PRODUCTTITLE T,
--      ALKINDI.MAP_PRODUCT MAP
--    WHERE
--      LOWER(T.TITLE) like V_SEARCH_TITLE and
--      T.PRODUCTAKATYPE = 'Primary Title' and
--      MAP.MAPPED_PRODUCT_ID = T.MUZEID and
--      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */ and
--	  rownum <= 100;
	OPEN o_SEARCH_cursor_type FOR
    SELECT /*+ FIRST_ROWS*/
      MAP.PRODUCT_ID
    FROM
      MUZE.VIDEOPRODUCT MP,
      MUZE.PRODUCTTITLE T,
      ALKINDI.MAP_PRODUCT MAP
    WHERE
      LOWER(LTRIM(TITLEARTICLE ||' '||TITLE)) like V_SEARCH_TITLE and
      T.PRODUCTAKATYPE = 'Primary Title' and
	  MP.MUZEID = T.MUZEID and
      MAP.MAPPED_PRODUCT_ID = MP.MUZEID and
      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */
	ORDER BY (nvl(MP.ORIGRELEASEYEAR,'0000')) DESC;


  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6205;						-- Movie not found - seaching by Primary Title
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_by_Primary_Title;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_by_Any_Title(
	i_TITLE					IN		MOVIE.TITLE%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)
  IS
	v_SEARCH_TITLE		 VARCHAR2(2000);
  BEGIN
	o_ERROR_CODE		:= 0;
	v_SEARCH_TITLE		:= lower('%'||i_TITLE||'%');

	OPEN o_SEARCH_cursor_type FOR
    SELECT /*+ FIRST_ROWS*/
      MAP.PRODUCT_ID
    FROM
      MUZE.VIDEOPRODUCT MP,
      MUZE.PRODUCTTITLE T,
      ALKINDI.MAP_PRODUCT MAP
    WHERE
      LOWER(LTRIM(TITLEARTICLE ||' '||TITLE)) like V_SEARCH_TITLE and
	  MP.MUZEID = T.MUZEID and
      MAP.MAPPED_PRODUCT_ID = MP.MUZEID and
      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */
	ORDER BY (nvl(MP.ORIGRELEASEYEAR,'0000')) DESC;
--    SELECT /*+FIRST_ROWS*/
--      MAP.PRODUCT_ID
--    FROM
--      MUZE.PRODUCTTITLE T    ,
--      ALKINDI.MAP_PRODUCT MAP
--    WHERE
--      LOWER(T.TITLE) like V_SEARCH_TITLE and
--      MAP.MAPPED_PRODUCT_ID = T.MUZEID and
--      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */ and
--	  rownum <= 100;

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6206;						-- Movie not found - seaching by Any Title
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_by_Any_Title;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_by_Director(
	i_DIRECTOR				IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS
	v_SEARCH_DIRECTOR		 VARCHAR2(2000);
  BEGIN
	o_ERROR_CODE		:= 0;
	v_SEARCH_DIRECTOR	:= lower('%'||i_DIRECTOR||'%');

	OPEN o_SEARCH_cursor_type FOR
--    SELECT /*+ FIRST_ROWS INDEX(C I_CONTRIBUTOR_NAME_LOWER)*/
--      MAP.PRODUCT_ID
--    FROM
--      MUZE.PRODCONTRIBJOB PC,
--      MUZE.CONTRIBUTOR C,
--      ALKINDI.MAP_PRODUCT MAP
--    WHERE
--      lower(C.firstname||' '||C.lastname) like v_SEARCH_DIRECTOR and
--      PC.CONTRIBID = C.CONTRIBID and
--      PC.CONTRIBAKANUM = C.CONTRIBAKANUM and
--      PC.JobID = 1001 /* Director */ and
--      PC.JobAkaNum = 1 /* Director */ and
--      MAP.MAPPED_PRODUCT_ID = PC.MUZEID and
--      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */ and
--	  rownum <= 100;
    SELECT /*+ FIRST_ROWS INDEX(C I_CONTRIBUTOR_NAME_LOWER)*/
      MAP.PRODUCT_ID
    FROM
      MUZE.VIDEOPRODUCT MP,
      MUZE.PRODCONTRIBJOB PC,
      MUZE.CONTRIBUTOR C,
      ALKINDI.MAP_PRODUCT MAP
    WHERE
      lower(C.firstname||' '||C.lastname) like v_SEARCH_DIRECTOR and
      PC.CONTRIBID = C.CONTRIBID and
      PC.CONTRIBAKANUM = C.CONTRIBAKANUM and
      PC.JobID = 1001 /* Director */ and
      PC.JobAkaNum = 1 /* Director */ and
	  MP.MUZEID = PC.MUZEID and
      MAP.MAPPED_PRODUCT_ID = MP.MUZEID and
      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */
	ORDER BY (nvl(MP.ORIGRELEASEYEAR,'0000')) DESC;

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6207;						-- Movie not found - seaching by Director
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_by_Director;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_by_Director_Sndex(
	i_DIRECTOR				IN		MOVIE.DIRECTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS
  BEGIN
	o_ERROR_CODE		:= 0;

	OPEN o_SEARCH_cursor_type FOR
    SELECT /*+FIRST_ROWS*/
      MAP.PRODUCT_ID
    FROM
      MUZE.PRODCONTRIBJOB PC,
      MUZE.CONTRIBUTOR C,
      ALKINDI.MAP_PRODUCT MAP
    WHERE
      soundex(C.firstname||' '||C.lastname) = soundex(i_DIRECTOR) and
      PC.CONTRIBID = C.CONTRIBID and
      PC.CONTRIBAKANUM = C.CONTRIBAKANUM and
      PC.JobID = 1001 /* Director */ and
      PC.JobAkaNum = 1 /* Director */ and
      MAP.MAPPED_PRODUCT_ID = PC.MUZEID and
      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */ and
	  rownum <= 100;

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6208;						-- Movie not found - seaching by Director Soundex
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_by_Director_Sndex;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_by_Actor(
	i_ACTOR			  	  	IN		MOVIE.ACTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS
	v_SEARCH_ACTOR		 VARCHAR2(2000);
  BEGIN
	o_ERROR_CODE		:= 0;
	v_SEARCH_ACTOR		:= lower('%'||i_ACTOR||'%');

	OPEN o_SEARCH_cursor_type FOR
    SELECT /*+ FIRST_ROWS */
      MAP.PRODUCT_ID
    FROM
      MUZE.VIDEOPRODUCT MP,
      ALKINDI.MAP_PRODUCT MAP,
      MUZE.PRODCONTRIBJOB PC,
      MUZE.CONTRIBUTOR C
    WHERE
      lower(C.firstname||' '||C.lastname) like v_SEARCH_ACTOR and
      PC.CONTRIBID = C.CONTRIBID and
      PC.CONTRIBAKANUM = C.CONTRIBAKANUM and
      PC.JobID in (1002 /* Star */,
                   1003 /* Featured */,
    			   1025 /* Cameo */,
    			   1033 /* Music Performer */,
    			   1041 /* Actor */,
    			   1128 /* Music Performer(s) */,
    			   1232 /* Star(s) */,
    			   1239 /* Performer(s) */,
    			   1237 /* Bit Part */,
    			   1253 /* Co-Star */,
    			   1254 /* Guest */,
    			   1256 /* Guest Performer */,
    			   1318 /* Star (uncredited) */) and
      PC.JobAkaNum = 1 and
      MP.MUZEID = PC.MUZEID and
      MAP.MAPPED_PRODUCT_ID = MP.MUZEID and
      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */
	ORDER BY (nvl(MP.ORIGRELEASEYEAR,'0000')) DESC,  lower(C.firstname||' '||C.lastname);

--    SELECT /*+FIRST_ROWS*/
--      MAP.PRODUCT_ID
--    FROM
--      ALKINDI.MAP_PRODUCT MAP
--    WHERE exists (
--    	SELECT
--    	   'x'
--        FROM
--          MUZE.PRODCONTRIBJOB PC,
--          MUZE.CONTRIBUTOR C
--        WHERE
--          lower(C.firstname||' '||C.lastname) like v_SEARCH_ACTOR and
--          PC.CONTRIBID = C.CONTRIBID and
--          PC.CONTRIBAKANUM = C.CONTRIBAKANUM and
--          PC.JobID in (1002 /* Star */,
--                       1003 /* Featured */,
--        			   1025 /* Cameo */,
--        			   1033 /* Music Performer */,
--        			   1041 /* Actor */,
--        			   1128 /* Music Performer(s) */,
--        			   1232 /* Star(s) */,
--        			   1239 /* Performer(s) */,
--        			   1237 /* Bit Part */,
--        			   1253 /* Co-Star */,
--        			   1254 /* Guest */,
--        			   1256 /* Guest Performer */,
--        			   1318 /* Star (uncredited) */) and
--          PC.JobAkaNum = 1 and
--          MAP.MAPPED_PRODUCT_ID = PC.MUZEID and
--          MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */) and
--	  rownum <= 100;


--    SELECT /*+FIRST_ROWS*/
--      MAP.PRODUCT_ID
--    FROM
--      MUZE.PRODCONTRIBJOB PC,
--      MUZE.CONTRIBUTOR C,
--      ALKINDI.MAP_PRODUCT MAP
--    WHERE
--      lower(C.firstname||' '||C.lastname) like v_SEARCH_ACTOR and
--      PC.CONTRIBID = C.CONTRIBID and
--      PC.CONTRIBAKANUM = C.CONTRIBAKANUM and
--      PC.JobID in (1002 /* Star */,
--                   1003 /* Featured */,
--    			   1025 /* Cameo */,
--    			   1033 /* Music Performer */,
--    			   1041 /* Actor */,
--    			   1128 /* Music Performer(s) */,
--    			   1232 /* Star(s) */,
--    			   1239 /* Performer(s) */,
--    			   1237 /* Bit Part */,
--    			   1253 /* Co-Star */,
--    			   1254 /* Guest */,
--    			   1256 /* Guest Performer */,
--    			   1318 /* Star (uncredited) */) and
--      PC.JobAkaNum = 1 and
--      MAP.MAPPED_PRODUCT_ID = PC.MUZEID and
--      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */ and
--	  rownum <= 100;

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6209;						-- Movie not found - seaching by Actor
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_by_Actor;

-- ==========================================================================================

  PROCEDURE sp_SEL_Movie_by_Actor_Soundex(
	i_ACTOR			  	  	IN		MOVIE.ACTOR%TYPE,
	o_SEARCH_cursor_type	OUT		SEARCH_cursor_type,
	o_ERROR_CODE			OUT		NUMBER)

  IS
  BEGIN
	o_ERROR_CODE		:= 0;

	OPEN o_SEARCH_cursor_type FOR
    SELECT /*+FIRST_ROWS*/
      MAP.PRODUCT_ID
    FROM
      MUZE.PRODCONTRIBJOB PC,
      MUZE.CONTRIBUTOR C,
      ALKINDI.MAP_PRODUCT MAP
    WHERE
      soundex(C.firstname||' '||C.lastname) = soundex(i_ACTOR) and
      PC.CONTRIBID = C.CONTRIBID and
      PC.CONTRIBAKANUM = C.CONTRIBAKANUM and
      PC.JobID in (1002 /* Star */,
                   1003 /* Featured */,
    			   1025 /* Cameo */,
    			   1033 /* Music Performer */,
    			   1041 /* Actor */,
    			   1128 /* Music Performer(s) */,
    			   1232 /* Star(s) */,
    			   1239 /* Performer(s) */,
    			   1237 /* Bit Part */,
    			   1253 /* Co-Star */,
    			   1254 /* Guest */,
    			   1256 /* Guest Performer */,
    			   1318 /* Star (uncredited) */) and
      PC.JobAkaNum = 1 and
      MAP.MAPPED_PRODUCT_ID = PC.MUZEID and
      MAP.PRODUCT_DB_SOURCE_ID = 1 /* Muze */ and
	  rownum <= 100;

  EXCEPTION
  	WHEN OTHERS THEN
  		o_ERROR_CODE	:= 6210;						-- Movie not found - seaching by Actor Soundex
  		CLOSE o_SEARCH_cursor_type;
  END sp_SEL_Movie_by_Actor_Soundex;

-- ==========================================================================================

END pkg_ALKINDI_SEARCH;
/
